<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDebtorsTable extends Migration {

	public function up()
	{
		Schema::create('debtors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->index();
			$table->string('phone', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('postal', 255)->nullable();
			$table->string('country', 255)->nullable();
			$table->tinyInteger('active')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('debtors');
	}
}