<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('debtors_users', function(Blueprint $table) {
			$table->foreign('debtor_id')->references('id')->on('debtors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debtors_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('websites', function(Blueprint $table) {
			$table->foreign('debtor_id')->references('id')->on('debtors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('websites_kpi', function(Blueprint $table) {
			$table->foreign('website_id')->references('id')->on('websites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('debtors_users', function(Blueprint $table) {
			$table->dropForeign('debtors_users_debtor_id_foreign');
		});
		Schema::table('debtors_users', function(Blueprint $table) {
			$table->dropForeign('debtors_users_user_id_foreign');
		});
		Schema::table('websites', function(Blueprint $table) {
			$table->dropForeign('websites_debtor_id_foreign');
		});
		Schema::table('websites_kpi', function(Blueprint $table) {
			$table->dropForeign('websites_kpi_website_id_foreign');
		});
	}
}