<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 255)->unique();
			$table->string('email', 255)->unique();
			$table->string('email_alt', 255)->unique()->nullable();
			$table->string('phone', 255);
			$table->string('lang', 255)->default('nl');
			$table->tinyInteger('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}