<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationDetailTable extends Migration {

	public function up()
	{
		Schema::create('education_detail', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('user_id')->unsigned();
			$table->string('degree', 50);
			$table->string('major', 50);
			$table->string('specialization', 50)->nullable();
			$table->string('university', 50);
			$table->date('starting_date');
			$table->date('completion_date');
			$table->float('gpa');
			$table->string('country', 50);
			$table->string('state', 50)->nullable();
			$table->string('city', 50);
			$table->string('status', 20);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('education_detail');
	}
}