<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperienceDetailTable extends Migration {

	public function up()
	{
		Schema::create('experience_detail', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('user_id')->unsigned();
			$table->string('is_current_job', 1)->default('n');
			$table->string('position', 50);
			$table->string('company', 50);
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('salary');
			$table->string('frequency', 50);
			$table->string('city', 50);
			$table->string('country', 50);
			$table->string('job_category', 50);
			$table->string('seniority_level', 50);
			$table->string('reporting_to', 20);
			$table->text('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('experience_detail');
	}
}