<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('candidate_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('education_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('experience_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reference_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('certificate_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skill_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('training_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('preference_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Post', function(Blueprint $table) {
			$table->foreign('company_id')->references('user_id')->on('company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_candidate_activity', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('Post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_candidate_activity', function(Blueprint $table) {
			$table->foreign('candidate_id')->references('user_id')->on('candidate_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('candidate_profile', function(Blueprint $table) {
			$table->dropForeign('candidate_profile_user_id_foreign');
		});
		Schema::table('education_detail', function(Blueprint $table) {
			$table->dropForeign('education_detail_user_id_foreign');
		});
		Schema::table('experience_detail', function(Blueprint $table) {
			$table->dropForeign('experience_detail_user_id_foreign');
		});
		Schema::table('reference_detail', function(Blueprint $table) {
			$table->dropForeign('reference_detail_user_id_foreign');
		});
		Schema::table('certificate_detail', function(Blueprint $table) {
			$table->dropForeign('certificate_detail_user_id_foreign');
		});
		Schema::table('skill_detail', function(Blueprint $table) {
			$table->dropForeign('skill_detail_user_id_foreign');
		});
		Schema::table('training_detail', function(Blueprint $table) {
			$table->dropForeign('training_detail_user_id_foreign');
		});
		Schema::table('preference_detail', function(Blueprint $table) {
			$table->dropForeign('preference_detail_user_id_foreign');
		});
		Schema::table('company', function(Blueprint $table) {
			$table->dropForeign('company_user_id_foreign');
		});
		Schema::table('Post', function(Blueprint $table) {
			$table->dropForeign('Post_company_id_foreign');
		});
		Schema::table('post_candidate_activity', function(Blueprint $table) {
			$table->dropForeign('post_candidate_activity_post_id_foreign');
		});
		Schema::table('post_candidate_activity', function(Blueprint $table) {
			$table->dropForeign('post_candidate_activity_candidate_id_foreign');
		});
	}
}