<?php

namespace App/Employer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'Post';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('App\Employer\Company', 'user_id');
	}

	public function activities()
	{
		return $this->hasMany('\PostCanAc', 'post_id');
	}

}