<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostCanAc extends Eloquent {

	protected $table = 'post_candidate_activity';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function post()
	{
		return $this->belongsTo('Post', 'id');
	}

	public function candidateProfile()
	{
		return $this->belongsTo('App\/Candidate\Profile', 'user_id');
	}

}