<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePedidosTable extends Migration {

	public function up()
	{
		Schema::create('pedidos', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('total');
			$table->string('estado', 100)->default('pendiente-de-pago');
			$table->string('transaction', 100)->nullable();
			$table->string('nombre', 100);
			$table->string('email', 100);
			$table->string('telefono', 20)->nullable();
			$table->string('direccion', 100);
			$table->string('cp', 5);
			$table->string('localidad', 100);
			$table->string('provincia', 100);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pedidos');
	}
}