<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_categoria')->unsigned();
			$table->string('nombre', 255)->nullable();
			$table->string('slug');
			$table->string('breadcrumb', 255)->nullable();
			$table->string('h1', 255)->nullable();
			$table->string('title', 255)->nullable();
			$table->string('description', 200)->nullable();
			$table->string('robots', 100);
			$table->string('canonical', 255)->nullable();
			$table->string('title_tc', 255)->nullable();
			$table->string('description_tc', 255)->nullable();
			$table->string('imagen_tc')->nullable();
			$table->string('title_og', 255)->nullable();
			$table->string('description_og')->nullable();
			$table->string('imagen_og');
			$table->text('descripcion_corta')->nullable();
			$table->text('descripcion_larga')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->timestamp('fecha_publicacion');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}