<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariantesTable extends Migration {

	public function up()
	{
		Schema::create('variantes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_producto')->unsigned();
			$table->string('referencia', 255);
			$table->string('anchor', 255);
			$table->decimal('precio');
			$table->decimal('precio_oferta');
			$table->string('disponibilidad', 255);
			$table->string('EAN', 15);
			$table->decimal('alto', 5,2)->nullable();
			$table->decimal('ancho', 5,2);
			$table->decimal('fondo', 5,2);
			$table->integer('orden');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('variantes');
	}
}