<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePedidosDetallesTable extends Migration {

	public function up()
	{
		Schema::create('pedidos_detalles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_pedido')->index();
			$table->integer('id_producto')->index();
			$table->integer('id_variante')->index();
			$table->decimal('precio_venta');
			$table->decimal('precio_normal');
			$table->decimal('precio_oferta')->nullable();
			$table->tinyInteger('disponibilidad')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pedidos_detalles');
	}
}