<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Categorias_blog extends Eloquent {

	protected $table = 'categorias_blog';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('\Post', 'id_categoria');
	}

	public function padre()
	{
		return $this->belongsTo('\Categorias_blog', 'id_padre');
	}

}