<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaracteristicasTable extends Migration {

	public function up()
	{
		Schema::create('caracteristicas', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre', 255)->nullable();
			$table->enum('tipo_dato', array('numerico', 'texto', 'lista'));
			$table->string('posibles_valores', 1020)->nullable();
			$table->string('previo', 100)->nullable();
			$table->string('posterior', 100)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('caracteristicas');
	}
}