<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannersTable extends Migration {

	public function up()
	{
		Schema::create('banners', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_tipo')->default('1');
			$table->smallInteger('orden')->nullable()->default('0');
			$table->string('nombre', 100)->nullable();
			$table->string('imagen', 100)->nullable();
			$table->string('alt', 100)->nullable();
			$table->string('url', 200)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('banners');
	}
}