<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('productos', function(Blueprint $table) {
			$table->foreign('id_categoria')->references('id')->on('categorias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('productos', function(Blueprint $table) {
			$table->foreign('id_marca')->references('id')->on('marcas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variantes', function(Blueprint $table) {
			$table->foreign('id_producto')->references('id')->on('productos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rel_caracteristicas', function(Blueprint $table) {
			$table->foreign('id_caracteristica')->references('id')->on('caracteristicas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('id_categoria')->references('id')->on('categorias_blog')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('productos', function(Blueprint $table) {
			$table->dropForeign('productos_id_categoria_foreign');
		});
		Schema::table('productos', function(Blueprint $table) {
			$table->dropForeign('productos_id_marca_foreign');
		});
		Schema::table('variantes', function(Blueprint $table) {
			$table->dropForeign('variantes_id_producto_foreign');
		});
		Schema::table('rel_caracteristicas', function(Blueprint $table) {
			$table->dropForeign('rel_caracteristicas_id_caracteristica_foreign');
		});
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_id_categoria_foreign');
		});
	}
}