<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Orphan extends Model 
{

    protected $table = 'orphan';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'name_en', 'name_ar', 'birth_date', 'birth_place', 'orphan_condition', 'parents_condition', 'live_with_family', 'colleagues');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

    public function requirements()
    {
        return $this->hasMany('HouseRequirement', 'orphan_id');
    }

}