<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrphanFamily extends Model 
{

    protected $table = 'orphan_family';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('orphan_id', 'name_en', 'name_ar', 'relative_status');

    public function orphan()
    {
        return $this->belongsTo('Orphan', 'orphan_id');
    }

}