<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserGoal extends Model 
{

    protected $table = 'user_goal';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'from_date', 'to_date', 'amount', 'general_requirements_amount', 'individual_requirement_amount', 'service_amount');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}