<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EquipmentReservation extends Model 
{

    protected $table = 'equipment_reservations';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function adress()
    {
        return $this->belongsTo('Adress');
    }

    public function group()
    {
        return $this->belongsTo('Group');
    }

    public function status()
    {
        return $this->belongsTo('Status');
    }

    public function parcels()
    {
        return $this->hasMany('EquipmentParcel');
    }

    public function items()
    {
        return $this->belongsToMany('EquipmentItem');
    }

}