<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentTable extends Migration {

	public function up()
	{
		Schema::create('content', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->text('video_link')->nullable();
			$table->bigInteger('summary_box')->unsigned();
			$table->bigInteger('special_points')->unsigned();
			$table->text('image_url')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('content');
	}
}