<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHmoCasesTable extends Migration {

	public function up()
	{
		Schema::create('hmo_cases', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('organisation_id')->nullable();
			$table->integer('status_id')->unsigned()->nullable();
			$table->string('reference', 255);
			$table->integer('property_id')->nullable();
			$table->boolean('licence_generated')->default(false);
			$table->timestamp('submitted_at')->nullable();
			$table->date('due_date')->nullable();
			$table->integer('close_reason')->nullable();
			$table->timestamp('landlord_last_updated')->nullable();
			$table->integer('new_messages')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hmo_cases');
	}
}