<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('loans', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('loans', function(Blueprint $table) {
			$table->foreign('loan_type_id')->references('id')->on('lone_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('endpoint_id')->references('id')->on('endpoints')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('msg_template_id')->references('id')->on('msg_templates')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('endpoints', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('doc_application', function(Blueprint $table) {
			$table->foreign('loan_type_id')->references('id')->on('lone_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doc_application', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('loans', function(Blueprint $table) {
			$table->dropForeign('loans_customer_id_foreign');
		});
		Schema::table('loans', function(Blueprint $table) {
			$table->dropForeign('loans_loan_type_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_endpoint_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_customer_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_msg_template_id_foreign');
		});
		Schema::table('endpoints', function(Blueprint $table) {
			$table->dropForeign('endpoints_customer_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_payment_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_media_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_customer_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_user_id_foreign');
		});
		Schema::table('doc_application', function(Blueprint $table) {
			$table->dropForeign('doc_application_loan_type_id_foreign');
		});
		Schema::table('doc_application', function(Blueprint $table) {
			$table->dropForeign('doc_application_document_id_foreign');
		});
	}
}