<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EndPoint extends Eloquent {

	protected $table = 'endpoints';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('type', 'code');

	public function Messages()
	{
		return $this->hasMany('Message');
	}

	public function Customer()
	{
		return $this->belongsTo('Customer');
	}

}