<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('address')->nullable();
			$table->float('geo_lat')->nullable();
			$table->float('geo_long')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}