<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_id()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function notifeable()
	{
		return $this->morphTo();
	}

}