<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('section_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->bigInteger('section_id')->unique()->unsigned();
			$table->string('locale')->unique();
		});
	}

	public function down()
	{
		Schema::drop('section_translations');
	}
}