<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatusTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('status_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('locale')->unique();
			$table->string('name');
			$table->text('description')->nullable();
			$table->bigInteger('status_id')->unique()->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('status_translations');
	}
}