<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaseExpensesTable extends Migration {

	public function up()
	{
		Schema::create('case_expenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('deposit_by_user_id')->unsigned();
			$table->bigInteger('deposit_for_user_id')->unsigned();
			$table->float('amount_paid');
			$table->bigInteger('case_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('case_expenses');
	}
}