<?php

namespace App\Models\Judgment;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Judgment extends Eloquent {

	protected $table = 'Judgment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('notes', 'case_status_id');

	public function status()
	{
		return $this->hasMany('Status');
	}

	public function case()
	{
		return $this->belongsTo('Xcase');
	}

}