<?php

namespace CourtItem;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CourtItem extends Model 
{

    protected $table = 'courts_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('court_type_id', 'court_name_id', 'case_id');

    public function courtType()
    {
        return $this->hasMany('CourtType', 'court_type_id');
    }

    public function courtName()
    {
        return $this->hasMany('CourtName');
    }

}