<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name');
			$table->string('email')->unique();
			$table->bigInteger('user_type_id')->unsigned();
			$table->date('birthdate')->nullable();
			$table->enum('gender', array(''male'', ''female''));
			$table->string('phone_number')->unique();
			$table->string('profile_image', 125);
			$table->string('identity_image');
			$table->integer('office_manager_membership_number')->unique();
			$table->string('role')->nullable();
			$table->enum('status', array('active', 'inactive'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}