<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateCvProfessionalExperienceTable extends Migration {

	public function up()
	{
		Schema::create('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('cv_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('currently_employed')->nullable()->default(0);
			$table->integer('location_id')->unsigned();
			$table->string('job_title', 60);
			$table->string('company_name', 60);
			$table->integer('company_size_id')->unsigned();
			$table->text('main_responsibilities');
			$table->text('main_achievement')->nullable();
			$table->string('reporting_to', 60)->nullable();
			$table->string('subordinate', 255)->nullable();
			$table->string('reason_to_leave', 255)->nullable();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('candidate_cv_professional_experience');
	}
}