<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatesCvTable extends Migration {

	public function up()
	{
		Schema::create('candidates_cv', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('candidate_id')->unsigned();
			$table->boolean('fresh_graduate')->nullable()->default(0);
			$table->integer('receive_job_update_alert_type_id')->unsigned();
			$table->text('comments')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('candidates_cv');
	}
}