<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('gender_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('how_find_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('nationality_1_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('nationality_2_id')->references('id')->on('candidates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('military_status_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('field_of_study_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('english_knowledge_level_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_phone_numbers', function(Blueprint $table) {
			$table->foreign('candidate_id')->references('id')->on('candidates')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_phone_numbers', function(Blueprint $table) {
			$table->foreign('country_code_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_phone_numbers', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates_cv', function(Blueprint $table) {
			$table->foreign('candidate_id')->references('id')->on('candidates')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates_cv', function(Blueprint $table) {
			$table->foreign('receive_job_update_alert_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('job_category_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('seniority_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('industry_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('company_size_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('company_nationality_type_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('salary_currency_type_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('salary_period_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->foreign('benefit_period_id')->references('id')->on('lookups')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_job_alert', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_job_alert', function(Blueprint $table) {
			$table->foreign('alert_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->foreign('company_size_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->foreign('university_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->foreign('field_of_study_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->foreign('degree_level_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_languages', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_languages', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_languages', function(Blueprint $table) {
			$table->foreign('language_skill_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_certificates', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_certificates', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_skills', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_skills', function(Blueprint $table) {
			$table->foreign('skill_level_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_skills', function(Blueprint $table) {
			$table->foreign('skill_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_additional_files', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_additional_files', function(Blueprint $table) {
			$table->foreign('file_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_saved_searchs', function(Blueprint $table) {
			$table->foreign('candidate_id')->references('id')->on('candidates')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('candidates_cv')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('career_level_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('willing_to_travel_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('employment_type_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('employment_status_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('salary_expected_currency_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->foreign('salary_expected_period_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_target_job_job_category', function(Blueprint $table) {
			$table->foreign('target_job_id')->references('id')->on('candidate_cv_target_job')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_target_job_job_category', function(Blueprint $table) {
			$table->foreign('job_category_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_target_job_job_industry', function(Blueprint $table) {
			$table->foreign('target_job_id')->references('id')->on('candidate_cv_target_job')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_target_job_job_industry', function(Blueprint $table) {
			$table->foreign('job_industry_id')->references('id')->on('lookups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_target_job_location', function(Blueprint $table) {
			$table->foreign('target_job_id')->references('id')->on('candidate_cv_target_job')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidate_target_job_location', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_gender_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_location_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_how_find_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_nationality_1_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_nationality_2_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_military_status_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_field_of_study_id_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_english_knowledge_level_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_parent_id_foreign');
		});
		Schema::table('candidate_phone_numbers', function(Blueprint $table) {
			$table->dropForeign('candidate_phone_numbers_candidate_id_foreign');
		});
		Schema::table('candidate_phone_numbers', function(Blueprint $table) {
			$table->dropForeign('candidate_phone_numbers_country_code_id_foreign');
		});
		Schema::table('candidate_phone_numbers', function(Blueprint $table) {
			$table->dropForeign('candidate_phone_numbers_type_id_foreign');
		});
		Schema::table('candidates_cv', function(Blueprint $table) {
			$table->dropForeign('candidates_cv_candidate_id_foreign');
		});
		Schema::table('candidates_cv', function(Blueprint $table) {
			$table->dropForeign('candidates_cv_receive_job_update_alert_type_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_cv_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_job_category_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_seniority_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_location_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_industry_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_company_size_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_company_nationality_type_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_salary_currency_type_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_salary_period_id_foreign');
		});
		Schema::table('candidate_cv_current_employment', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_current_employment_benefit_period_id_foreign');
		});
		Schema::table('candidate_cv_job_alert', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_job_alert_cv_id_foreign');
		});
		Schema::table('candidate_cv_job_alert', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_job_alert_alert_type_id_foreign');
		});
		Schema::table('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_professional_experience_cv_id_foreign');
		});
		Schema::table('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_professional_experience_location_id_foreign');
		});
		Schema::table('candidate_cv_professional_experience', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_professional_experience_company_size_id_foreign');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_educations_cv_id_foreign');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_educations_university_type_id_foreign');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_educations_field_of_study_id_foreign');
		});
		Schema::table('candidate_cv_educations', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_educations_degree_level_id_foreign');
		});
		Schema::table('candidate_cv_languages', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_languages_cv_id_foreign');
		});
		Schema::table('candidate_cv_languages', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_languages_language_id_foreign');
		});
		Schema::table('candidate_cv_languages', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_languages_language_skill_id_foreign');
		});
		Schema::table('candidate_cv_certificates', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_certificates_cv_id_foreign');
		});
		Schema::table('candidate_cv_certificates', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_certificates_location_id_foreign');
		});
		Schema::table('candidate_cv_skills', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_skills_cv_id_foreign');
		});
		Schema::table('candidate_cv_skills', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_skills_skill_level_id_foreign');
		});
		Schema::table('candidate_cv_skills', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_skills_skill_type_id_foreign');
		});
		Schema::table('candidate_cv_additional_files', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_additional_files_cv_id_foreign');
		});
		Schema::table('candidate_cv_additional_files', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_additional_files_file_type_id_foreign');
		});
		Schema::table('candidate_saved_searchs', function(Blueprint $table) {
			$table->dropForeign('candidate_saved_searchs_candidate_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_cv_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_career_level_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_willing_to_travel_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_employment_type_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_employment_status_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_salary_expected_currency_id_foreign');
		});
		Schema::table('candidate_cv_target_job', function(Blueprint $table) {
			$table->dropForeign('candidate_cv_target_job_salary_expected_period_id_foreign');
		});
		Schema::table('candidate_target_job_job_category', function(Blueprint $table) {
			$table->dropForeign('candidate_target_job_job_category_target_job_id_foreign');
		});
		Schema::table('candidate_target_job_job_category', function(Blueprint $table) {
			$table->dropForeign('candidate_target_job_job_category_job_category_id_foreign');
		});
		Schema::table('candidate_target_job_job_industry', function(Blueprint $table) {
			$table->dropForeign('candidate_target_job_job_industry_target_job_id_foreign');
		});
		Schema::table('candidate_target_job_job_industry', function(Blueprint $table) {
			$table->dropForeign('candidate_target_job_job_industry_job_industry_id_foreign');
		});
		Schema::table('candidate_target_job_location', function(Blueprint $table) {
			$table->dropForeign('candidate_target_job_location_target_job_id_foreign');
		});
		Schema::table('candidate_target_job_location', function(Blueprint $table) {
			$table->dropForeign('candidate_target_job_location_location_id_foreign');
		});
	}
}