<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AdditionalFile extends Eloquent {

	protected $table = 'candidate_cv_additional_files';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'name', 'path', 'file_type_id');

	public function cv()
	{
		return $this->belongsTo('App\CandidateCV', 'cv_id');
	}

	public function fileType()
	{
		return $this->belongsTo('App\Lookup', 'file_type_id');
	}

}