<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CandidateCV extends Eloquent {

	protected $table = 'candidates_cv';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('candidate_id', 'fresh_graduate', 'receive_job_update_alert_type_id', 'comments');

	public function candidate()
	{
		return $this->belongsTo('App\Candidate');
	}

	public function cvCurrentEmployment()
	{
		return $this->hasOne('App\CurrentEmployment', 'cv_id');
	}

	public function jobAlerts()
	{
		return $this->belongsToMany('App\Lookup', 'candidate_cv_job_alert', 'cv_id', 'alert_type_id');
	}

	public function cvProfessionalExperiences()
	{
		return $this->hasMany('App\ProfessionalExperience', 'cv_id');
	}

	public function cvEducations()
	{
		return $this->hasMany('App\Education', 'cv_id');
	}

	public function cvLanguages()
	{
		return $this->hasMany('App\Language', 'cv_id');
	}

	public function cvCertificates()
	{
		return $this->hasMany('App\Certificate', 'cv_id');
	}

	public function cvSkills()
	{
		return $this->hasMany('App\Skill', 'cv_id');
	}

	public function cvAdditionalFiles()
	{
		return $this->hasMany('App\AdditionalFile', 'cv_id');
	}

	public function targetJob()
	{
		return $this->hasOne('App\TargetJob', 'cv_id');
	}

}