<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Language extends Eloquent {

	protected $table = 'candidate_cv_languages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'language_id', 'language_skill_id');

	public function cv()
	{
		return $this->belongsTo('App\CandidateCV', 'cv_id');
	}

	public function language()
	{
		return $this->belongsTo('App\Lookup', 'language_id');
	}

	public function languageSkill()
	{
		return $this->belongsTo('App\Lookup', 'language_skill_id');
	}

}