<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Certificate extends Eloquent {

	protected $table = 'candidate_cv_certificates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'title', 'issuer', 'issue_date', 'location_id');

	public function cv()
	{
		return $this->belongsTo('App\CandidateCV', 'cv_id');
	}

	public function location()
	{
		return $this->belongsTo('App\Location');
	}

}