<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProfessionalExperience extends Eloquent {

	protected $table = 'candidate_cv_professional_experience';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'start_date', 'end_date', 'currently_employed', 'location_id', 'job_title', 'company_name', 'company_size_id', 'main_responsibilities', 'main_achievement', 'reporting_to', 'subordinate', 'reason_to_leave', 'description');

	public function cv()
	{
		return $this->belongsTo('App\CandidateCV', 'cv_id');
	}

	public function location()
	{
		return $this->belongsTo('App\Location');
	}

	public function companySize()
	{
		return $this->belongsTo('App\Lookup', 'company_size_id');
	}

}