<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TargetJob extends Eloquent {

	protected $table = 'candidate_cv_target_job';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'title', 'career_level_id', 'career_objectives', 'willing_to_relocate', 'willing_to_travel_id', 'employment_type_id', 'employment_status_id', 'salary_expected', 'salary_expected_currency_id', 'salary_expected_period_id', 'expected_benefits');

	public function careerLevel()
	{
		return $this->belongsTo('App\Lookup', 'career_level_id');
	}

	public function willingToTravel()
	{
		return $this->belongsTo('App\Lookup', 'willing_to_travel_id');
	}

	public function employmentType()
	{
		return $this->belongsTo('App\Lookup', 'employment_type_id');
	}

	public function employmentStatus()
	{
		return $this->belongsTo('App\Lookup', 'employment_status_id');
	}

	public function salaryExpectedCurrency()
	{
		return $this->belongsTo('App\Candidate', 'salary_expected_currency_id');
	}

	public function salaryExpectedCurrencyPeriod()
	{
		return $this->belongsTo('App\Lookup', 'salary_expected_period_id');
	}

	public function cv()
	{
		return $this->hasOne('App\CandidateCV', 'cv_id');
	}

	public function jobCategories()
	{
		return $this->hasMany('App\Lookup', 'candidate_target_job_job_category', 'target_job_id', 'job_category_id');
	}

	public function jobIndustries()
	{
		return $this->belongsTo('App\Lookup', 'candidate_target_job_job_industry', 'target_job_id', 'job_industry_id');
	}

	public function jobLocations()
	{
		return $this->belongsToMany('App\Location', 'candidate_target_job_job_location', 'target_job_id', 'location_id');
	}

}