<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Candidate extends Model 
{

    protected $table = 'candidates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');
    protected $fillable = array('gender_id', 'first_name', 'surname', 'email', 'location_id', 'email2', 'how_find_id', 'how_find_other', 'date_of_birth', 'nationality_1_id', 'nationality_2_id', 'marital_status', 'military_status_id', 'has_degree', 'field_of_study_id', 'english_knowledge_level_id', 'mailshot_career_related_news', 'mailshot_event_product_service');

    public function title()
    {
        return $this->belongsTo('App\Lookup', 'title_id');
    }

    public function howFind()
    {
        return $this->belongsTo('App\Lookup', 'how_find_id');
    }

    public function militaryStatus()
    {
        return $this->belongsTo('App\Lookup', 'military_status_id');
    }

    public function fieldOfStudy()
    {
        return $this->belongsTo('App\Lookup', 'field_of_study_id');
    }

    public function englishKnowledgeLevel()
    {
        return $this->belongsTo('App\Lookup', 'english_knowledge_level_id');
    }

    public function location()
    {
        return $this->belongsTo('App\Location', 'location_id');
    }

    public function nationality1()
    {
        return $this->belongsTo('App\Location', 'nationality_1');
    }

    public function nationality2()
    {
        return $this->belongsTo('App\Location', 'nationality_2');
    }

    public function phoneNumbers()
    {
        return $this->hasMany('App\CandidatePhoneNumber');
    }

    public function cv()
    {
        return $this->hasMany('App\CandidateCV');
    }

    public function savedSearch()
    {
        return $this->hasMany('App\CandidateSavedSearch');
    }

}