<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lookup extends Model 
{

    protected $table = 'lookups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'title_farsi', 'sequence', 'subscriber_count', 'value', 'type', 'description');

    public function candidatesByTitle()
    {
        return $this->hasMany('App\Candidate', 'title_id');
    }

    public function candidatesByHowFind()
    {
        return $this->hasMany('App\Candidate', 'how_find_id');
    }

    public function candidatesByMilitaryStatus()
    {
        return $this->hasMany('App\Candidate', 'military_status_id');
    }

    public function candidatesByFieldOfStudy()
    {
        return $this->hasMany('App\Candidate', 'field_of_study_id');
    }

    public function candidatesByEnglishKnowledgeLevel()
    {
        return $this->hasMany('App\Candidate', 'english_knowledge_level_id');
    }

    public function phoneNumbers()
    {
        return $this->hasMany('App\CandidatePhoneNumber', 'type_id');
    }

    public function currentEmploymentByJobCategory()
    {
        return $this->hasMany('App\CurrentEmployment', 'job_category_id');
    }

    public function currentEmploymentBySeniority()
    {
        return $this->hasMany('App\CurrentEmployment', 'seniority_id');
    }

    public function currentEmploymentByIndustry()
    {
        return $this->hasMany('App\CurrentEmployment', 'industry_id');
    }

    public function currentEmploymentByCompanySize()
    {
        return $this->hasMany('App\CurrentEmployment', 'company_size_id');
    }

    public function currentEmploymentByCompanyNationalityType()
    {
        return $this->hasMany('App\CurrentEmployment', 'company_nationality_type_id');
    }

    public function currentEmploymentBySalaryCurrencyType()
    {
        return $this->hasMany('App\CurrentEmployment', 'salary_currency_type_id');
    }

    public function currentEmploymentBySalaryPeriod()
    {
        return $this->hasMany('App\CurrentEmployment', 'salary_period_id');
    }

    public function currentEmploymentByBenefitPeriod()
    {
        return $this->hasMany('App\CurrentEmployment', 'benefit_period_id');
    }

    public function candidatesByJobAlert()
    {
        return $this->belongsToMany('App\CandidateCV', 'candidate_cv_job_alert', 'alert_type_id', 'cv_id');
    }

    public function candidateProfessionalExperiencesByCampanySize()
    {
        return $this->hasMany('App\ProfessionalExperience', 'company_size_id');
    }

    public function candidateEducationsByUniversityType()
    {
        return $this->hasMany('App\Education', 'university_type_id');
    }

    public function candidateEducationsByFieldOfStudy()
    {
        return $this->hasMany('App\Education', 'field_of_study_id');
    }

    public function candidateEducationsByDegreeLevel()
    {
        return $this->hasMany('App\Education', 'degree_level_id');
    }

    public function candidateLanguageSkillsByLanguage()
    {
        return $this->hasMany('App\Language', 'language_id');
    }

    public function candidateLanguageSkillsByLanguageLevel()
    {
        return $this->hasMany('App\Language', 'language_skill_id');
    }

    public function candidateSkillsBySkillLevel()
    {
        return $this->hasMany('App\Skill', 'skill_level_id');
    }

    public function candidateAdditionalFilesByType()
    {
        return $this->hasMany('App\AdditionalFile', 'file_type_id');
    }

    public function candidateTargetJobByCareerLevel()
    {
        return $this->hasMany('App\TargetJob', 'career_level_id');
    }

    public function candidateTargetJobByWillingToTravelType()
    {
        return $this->hasMany('App\TargetJob', 'willing_to_travel_id');
    }

    public function candidateTargetJobByEmploymentType()
    {
        return $this->hasMany('App\TargetJob', 'employment_type_id');
    }

    public function candidateTargetJobBySalaryExpectedCurrencyType()
    {
        return $this->hasMany('App\TargetJob', 'salary_expected_currency_id');
    }

    public function candidateTargetJobBySalaryExpectedPeriod()
    {
        return $this->hasMany('App\TargetJob', 'salary_expected_period_id');
    }

    public function targetJobsByJobCategory()
    {
        return $this->belongsToMany('App\TargetJob', 'candidate_target_job_job_category', 'job_category_id', 'target_job_id');
    }

    public function targetJobsByJobIndustry()
    {
        return $this->belongsToMany('App\TargetJob', 'candidate_target_job_job_industry', 'job_industry_id', '', 'target_job_i');
    }

}