<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DirectSell extends Model 
{

    protected $table = 'direct_sells';
    public $timestamps = true;
    protected $fillable = array('seller_id', 'grand_total');
    protected $visible = array('grand_total');

    public function packages()
    {
        return $this->hasMany('SoldPackage', 'direct_sells_id');
    }

    public function notes()
    {
        return $this->morphMany('Note', 'commentable');
    }

}