<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VIPSell extends Model 
{

    protected $table = 'vip_sells';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('seller_id', 'pax', 'total_price', 'table_code');
    protected $visible = array('pax', 'total_price', 'table_code');

    public function notes()
    {
        return $this->morphMany('Note', 'commentable');
    }

}