<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgenciesTable extends Migration {

	public function up()
	{
		Schema::create('agencies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->unique();
			$table->string('registered_name', 100);
			$table->string('rnc', 50)->unique();
			$table->string('email', 100);
			$table->string('phone', 20);
			$table->text('address');
			$table->text('description')->nullable();
			$table->boolean('enable')->default(true);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('agencies');
	}
}