<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVipSellsTable extends Migration {

	public function up()
	{
		Schema::create('vip_sells', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('seller_id')->unsigned();
			$table->integer('pax');
			$table->decimal('total_price', 10,4);
			$table->string('table_code', 20);
			$table->boolean('is_credit_card')->nullable();
			$table->string('cc_confirmation_code')->nullable();
			$table->integer('reservation_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vip_sells');
	}
}