<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HotelRoute extends Eloquent {

	protected $table = 'hotel_route';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function hotels()
	{
		return $this->hasMany('Hotel', 'id');
	}

	public function routes()
	{
		return $this->hasMany('Route', 'id');
	}

}