<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PackageAction extends Eloquent {

	protected $table = 'package_actions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('reseptionist_id', 'action_id', 'pax', 'date', 'extra_price');
	protected $visible = array('action_id', 'pax', 'date', 'extra_price');

	public function action()
	{
		return $this->belongsTo('Action', 'action_id');
	}

	public function reservationPackage()
	{
		return $this->belongsTo('ReservationPackage', 'reservation_package_id');
	}

}