<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VIPSell extends Eloquent {

	protected $table = 'vip_sells';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('seller_id', 'pax', 'total_price', 'table_code');
	protected $visible = array('pax', 'total_price', 'table_code');

	public function notes()
	{
		return $this->morphMany('Note', 'commentable');
	}

}